###############################################################
# R code: Exercise 9.2(b)
# File: Local-constant-regression.r
#
# Local constant regression with a Gaussian product kernel 
# and a single bandwidth obtained using cross-validation.
#
# INPUT: 
# pset   = size of prediction set (here 12)
# p      = Markov order (here 2).            
# OUTPUT: 
# Ylc  = (pset * 1) vector of forecasts  
################################################################
library(np)
zGSL   <- scale(GSL519) # standardized data
zGSLt  <- ts(zGSL)
nr     <- length(zGSLt)
p      <- 2    # lag length (Markov order)
pset   <- 12 
n      <- nr-pset-p 
lagmat <- function(x,max.lag) embed(c(rep(NA,max.lag),x),max.lag+1)
xlag   <- lagmat(zGSLt,p)
Ylc    <- matrix(0,nrow=pset,ncol=1)
for (i in 1:pset){
  Xactual <- window(cbind(xlag[3:nr,2],xlag[nc:nr,3]),end=n+i)
  Yactual <- window(cbind(xlag[3:nr,1]),end=n+i)
  Yc      <- c(Yactual)
  bw      <- npregbw(xdat=Xactual,ydat=Yc)
  fit.lc  <- npksum(txdat=Xactual,tydat=Yc,bws=bw$bw)$ksum/
             npksum(txdat=Xactual,bws=bw$bw)$ksum
  Ylc[i,] <- fit.lc[n+i]  
 }
